/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2000 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PSFilter.h
//
//	Description:
//		FilterPlugin class implementation.
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#ifndef __PSFilter_H__
#define __PSFilter_H__

#include "PSPlugIn.h"
#include "PIFilter.h"

class FilterPlugin : public PSPlugin {
private: 
	virtual void Parameters(void) = 0;
	virtual void Prepare(void) = 0;
	virtual void Start(void) = 0;
	virtual void Continue(void) = 0;
	virtual void Finish(void) = 0;

	FilterPlugin(); // don't define this
	FilterPlugin(FilterPlugin&); // don't define this

public:
	FilterRecord*	filterRecord;
	long*			data;

	FilterPlugin(HANDLE hDLLInstance) : PSPlugin(hDLLInstance), 
		                                filterRecord(NULL),
										data(NULL) {}
	~FilterPlugin() {}


public:
	void SetFilterRecord(FilterRecord* filterRec) 
	{ 
		filterRecord = filterRec; 
	}
	
	void SetData(int32* d) 
	{ 
		data = d; 
	}

	virtual void HandleMessage(const char selector) 
	{ 
		switch (selector)
		{
			case filterSelectorAbout:
				About();
				break;
			case filterSelectorParameters:
				Parameters();
				break;
			case filterSelectorPrepare:
				Prepare();
				break;
			case filterSelectorStart:
				Start();
				break;
			case filterSelectorContinue:
				Continue();
				break;
			case filterSelectorFinish:
				Finish();
				break;
			default:
				throw(errPlugInHostInsufficient);
				break;
		}
	}
};
#endif
// end PSFilter.h